<?php
require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/helpers.php';

$nowDate = date('Y-m-d');
$nowTime = date('H:i');
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Waste Segregation - Officer</title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
  <main class="container">
    <header>
      <div>
        <h1>Waste Segregation — Revisit</h1>
        <p class="lead">Fetch resident details by Mobile No. — update training records</p>
      </div>
      <div class="lead">Today: <span id="now-label"><?= htmlspecialchars("$nowDate $nowTime") ?></span></div>
    </header>

    <div id="top-error" class="top-error" style="display:none"></div>

    <form id="officer-form" action="submit.php" method="post" novalidate>
      <input type="hidden" name="flow" value="officer">
      <input type="hidden" name="resident_id" id="resident_id" value="">
      <input type="hidden" name="geo_lat" id="geo_lat_off">
      <input type="hidden" name="geo_lng" id="geo_lng_off">
      <input type="hidden" name="geo_acc" id="geo_acc_off">
      <input type="hidden" name="geo_addr" id="geo_addr_off">
      <input type="hidden" name="geo_village" id="geo_village_off">
      <input type="hidden" name="geo_district" id="geo_district_off">
      <input type="hidden" name="geo_state" id="geo_state_off">
      <input type="hidden" name="geo_country" id="geo_country_off">
      <input type="hidden" name="geo_cc" id="geo_cc_off">
      <input type="hidden" name="captured_at" id="captured_at_off">

      <div class="field full">
        <label for="lookup_phone">Enter Registered Mobile number to Get Details  <span class="req-inline">*</span></label>
        <div style="display:flex;gap:8px;align-items:center">
          <input id="lookup_phone" name="lookup_phone" type="tel" maxlength="10" placeholder="Mobile number (not  include +91)" required>
          <button type="button" id="lookup" class="btn primary">Get Details</button>
        </div>
      </div>

      <!-- ====== Resident data (styled card) ====== -->
      <div id="resident-data" style="display:none; margin-top:12px">

        <!-- Resident Details card -->
        <section class="resident-card group-bg">
          <div class="section-title-row">
            <h3 class="section-title">Resident Details</h3>
          </div>

          <div class="resident-grid">
            <div class="resident-row">
              <div class="resident-label">Ward</div>
              <div class="resident-value"><div class="value-field" id="r_ward">—</div></div>
            </div>

            <div class="resident-row">
              <div class="resident-label">House No.</div>
              <div class="resident-value"><div class="value-field" id="r_house_no">—</div></div>
            </div>

            <div class="resident-row">
              <div class="resident-label">Name</div>
              <div class="resident-value"><div class="value-field" id="r_name">—</div></div>
            </div>

            <div class="resident-row">
              <div class="resident-label">Mobile number</div>
              <div class="resident-value"><div class="value-field" id="r_phone">—</div></div>
            </div>
          </div>
        </section>

        <!-- Previous trainings: older JS may append into this; keep it present -->
        <div id="previous-trainings" style="margin-top:18px"></div>

        <!-- Training-list (for newer rendering) -->
        <div id="training-list" style="margin-top:8px;"></div>

        <hr style="border:none;border-top:1px solid rgba(10,20,40,0.06);margin:18px 0">

        <!-- Next training (this visit) -->
        <div id="next-training-section" class="next-training group-bg" style="padding:12px;border-radius:10px">
          <h3 id="next-training-label" style="margin-top:0;color:var(--gov-blue)">Training (This Visit)</h3>

          <div class="field">
            <label>Waste Segregation (this visit) <span class="req-inline">*</span></label>
            <div class="radio-row">
              <label class="radio-label"><input type="radio" name="waste_segregation" value="yes" required> Yes</label>
              <label class="radio-label"><input type="radio" name="waste_segregation" value="no"> No</label>
            </div>
            <div id="err-waste" class="error">Choose yes or no</div>
          </div>

          <div class="field full camera-wrap" style="margin-top:8px">
            <label>Photo for this visit <span class="req-inline">*</span></label>
            <div id="camera-area-officer">
              <video id="video" autoplay playsinline style="display:none;"></video>
              <canvas id="canvas" style="display:none"></canvas>

              <div class="camera-controls" style="display:flex;gap:8px;margin-top:8px">
                <button type="button" id="open-camera-off" class="btn">Open Camera</button>
                <button type="button" id="take-photo-off" class="btn" style="display:none">Take Photo</button>
                <button type="button" id="retake-photo-off" class="btn ghost" style="display:none">Retake</button>
              </div>

              <input type="hidden" name="photo_data" id="photo_data_off">
              <div id="photo-preview-off" style="margin-top:10px"></div>
              <div id="err-photo" class="error">Photo is required</div>
            </div>
          </div>

          <div class="field-grid" style="margin-top:10px;display:grid;grid-template-columns:1fr 1fr;gap:12px;">
            <div class="field">
              <label for="r_date">Date</label>
              <input id="r_date" name="date" type="date" value="<?= $nowDate ?>" required>
            </div>
            <div class="field">
              <label for="r_time">Time</label>
              <input id="r_time" name="time" type="time" value="<?= $nowTime ?>" required>
            </div>
          </div>

          <div class="actions full actions-center" style="margin-top:12px">
            <!-- Save uses same primary button style -->
            <button type="button" id="save-training" class="btn primary large">Save Training</button>
          </div>
        </div>

      </div> <!-- /resident-data -->
    </form>
  </main>

  <?php $cfg = require __DIR__ . '/../includes/config.php'; ?>
<script>
window.APP_CFG = {
  MAPBOX_TOKEN: "<?= htmlspecialchars($cfg['mapbox_token'] ?? '') ?>",
  GOOGLE_KEY: "<?= htmlspecialchars($cfg['google_key'] ?? '') ?>"
};
</script>
  <script src="assets/app.js?v=6"></script>

  <script>
    // small now label
    const nowLabel = document.getElementById('now-label');
    // no-op here; app.js handles lookup wiring
  
  
  <!-- Lightbox: show tapped/clicked image larger (works for dynamically created images) -->

</script>
<script>
/* Robust lightbox (single instance) — works with dynamically inserted images.
   Place this after your app.js include in both pages.
*/
(function(){
  // Create single lightbox elements and attach handlers
  if (document.querySelector('.lightbox-backdrop')) {
    // already present (safety)
    return;
  }

  const backdrop = document.createElement('div');
  backdrop.className = 'lightbox-backdrop';
  backdrop.setAttribute('aria-hidden', 'true');

  const inner = document.createElement('div');
  inner.className = 'lightbox-inner';

  const loader = document.createElement('div');
  loader.className = 'lightbox-loader';
  loader.style.display = 'none';

  const img = document.createElement('img');
  img.className = 'lightbox-img';
  img.alt = 'Photo preview';
  img.style.display = 'none';

  const closeBtn = document.createElement('button');
  closeBtn.className = 'lightbox-close';
  closeBtn.innerHTML = '✕';
  closeBtn.setAttribute('aria-label', 'Close preview');

  // assemble
  inner.appendChild(loader);
  inner.appendChild(img);
  inner.appendChild(closeBtn);
  backdrop.appendChild(inner);
  document.body.appendChild(backdrop);

  // helper functions
  let currentSrc = '';
  function show(src) {
    if (!src) return;
    currentSrc = src;
    backdrop.style.display = 'flex';
    backdrop.setAttribute('aria-hidden', 'false');
    document.body.style.overflow = 'hidden';

    // show loader while image loads
    loader.style.display = '';
    img.style.display = 'none';
    img.src = ''; // reset

    // pre-load image
    const tmp = new Image();
    tmp.onload = function() {
      // success — set src and show
      img.src = src;
      loader.style.display = 'none';
      img.style.display = '';
      // ensure focus for accessibility
      closeBtn.focus({preventScroll:true});
    };
    tmp.onerror = function() {
      loader.style.display = 'none';
      img.style.display = 'none';
      // fallback: show a small error message
      const err = document.createElement('div');
      err.style.color = '#fff';
      err.style.padding = '8px';
      err.textContent = 'Could not load image.';
      // remove any previous error nodes
      const previous = inner.querySelector('.lb-error');
      if (previous) previous.remove();
      err.className = 'lb-error';
      inner.appendChild(err);
      setTimeout(()=> { if (err) err.remove(); }, 2500);
    };
    tmp.src = src;
  }

  function hide() {
    backdrop.style.display = 'none';
    backdrop.setAttribute('aria-hidden', 'true');
    document.body.style.overflow = '';
    img.src = '';
    currentSrc = '';
    // remove any transient error nodes
    const previous = inner.querySelector('.lb-error');
    if (previous) previous.remove();
  }

  // event wiring
  closeBtn.addEventListener('click', hide);
  // click outside to close
  backdrop.addEventListener('click', (ev) => {
    if (ev.target === backdrop) hide();
  });
  // escape key
  document.addEventListener('keydown', (ev) => { if (ev.key === 'Escape') hide(); });

  // delegate clicks/taps on images (works for dynamic inserts)
  document.addEventListener('click', function(e) {
    const t = e.target;
    if (!t) return;
    // Only open when clicking the actual image (not its container) OR clicking inside .training-image wrapper
    let targetImg = null;
    if (t.tagName === 'IMG' && (t.closest('.training-image') || t.closest('#previous-trainings') || t.closest('#training-list') || t.closest('#reg-photo') || t.closest('#photo-preview'))) {
      targetImg = t;
    } else {
      // if clicked wrapper with an image inside
      const wrapper = t.closest('.training-image, #previous-trainings, #training-list, #reg-photo, #photo-preview');
      if (wrapper) {
        targetImg = wrapper.querySelector('img');
      }
    }
    if (targetImg && targetImg.src) {
      // prevent default link behavior if inside an <a>
      if (e.defaultPrevented) return;
      e.preventDefault && e.preventDefault();
      show(targetImg.src);
    }
  }, { passive: false });

})();
</script>

</body>
</html>
