<?php
require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/helpers.php';

$nowDate = date('Y-m-d');
$nowTime = date('H:i');
$wards = ['W1','W2','W3','W4','W5'];
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Waste Segregation - Registration</title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
  <main class="container">
    <header class="page-header">
      <h1 class="title">Waste Segregation — Registration</h1>
      <div class="now">Today: <span id="now-label"><?= htmlspecialchars("$nowDate $nowTime") ?></span></div>
    </header>

    <div id="top-error" class="top-error" aria-live="polite" style="display:none"></div>

    <form id="reg-form" action="submit.php" method="post" novalidate class="form-card">
      <input type="hidden" name="flow" value="register">
      <input type="hidden" name="geo_lat" id="geo_lat">
      <input type="hidden" name="geo_lng" id="geo_lng">
      <input type="hidden" name="geo_acc" id="geo_acc">
      <input type="hidden" name="geo_addr" id="geo_addr">
      <input type="hidden" name="geo_village" id="geo_village">
      <input type="hidden" name="geo_district" id="geo_district">
      <input type="hidden" name="geo_state" id="geo_state">
      <input type="hidden" name="geo_country" id="geo_country">
      <input type="hidden" name="geo_cc" id="geo_cc">
      <input type="hidden" name="captured_at" id="captured_at">

      <div class="col-grid">

  <div class="field group-bg">
    <input id="date" name="date" type="date" value="<?= $nowDate ?>" required placeholder="Date">
  </div>

  <div class="field group-bg">
    <input id="time" name="time" type="time" value="<?= $nowTime ?>" required placeholder="Time">
  </div>

  <div class="field group-bg">
    <select id="ward" name="ward" required>
      <option value="">Select Ward</option>
      <?php foreach($wards as $w): ?>
        <option value="<?=htmlspecialchars($w)?>"><?=htmlspecialchars($w)?></option>
      <?php endforeach; ?>
    </select>
    <div id="err-ward" class="error">Ward is required</div>
  </div>

  <div class="field group-bg">
    <input id="house_no" name="house_no" type="text" required placeholder="House No.">
    <div id="err-house" class="error">House number is required</div>
  </div>

  <div class="field group-bg">
    <input id="name" name="name" type="text" required placeholder="Name">
    <div id="err-name" class="error">Name is required</div>
  </div>

  <div class="field group-bg">
    <input id="phone" name="phone" type="tel" maxlength="10" inputmode="numeric" required placeholder="Mobile number (not include +91)">
    <div id="err-phone" class="error">Enter a valid 10-digit phone</div>
    <div class="hint" id="phone-msg"></div>
  </div>

  <!-- Waste segregation keeps label -->
  <div class="field full group-bg">
    <label>Waste Segregation <span class="req-inline">*</span></label>
    <div class="radio-row">
      <label class="radio-label"><input type="radio" name="waste_segregation" value="yes" required> Yes</label>
      <label class="radio-label"><input type="radio" name="waste_segregation" value="no"> No</label>
    </div>
    <div id="err-waste" class="error">Choose yes or no</div>
  </div>

  <!-- Camera capture also keeps label -->
  <div class="field full group-bg camera-wrap">
    <label>Photo (capture) <span class="req-inline">*</span></label>
    <div id="camera-area">
      <video id="video" autoplay playsinline></video>
      <canvas id="canvas" style="display:none"></canvas>

      <div class="camera-controls">
        <button type="button" id="open-camera" class="btn">Open Camera</button>
        <button type="button" id="take-photo" class="btn" style="display:none">Take Photo</button>
        <button type="button" id="retake-photo" class="btn ghost" style="display:none">Retake</button>
      </div>

      <input type="hidden" name="photo_data" id="photo_data">
      <div id="photo-preview" class="photo-preview" aria-live="polite"></div>
      <div id="err-photo" class="error">Photo is required</div>
    </div>
  </div>
</div>


      <div class="actions full actions-center">
        <button type="button" id="save-register" class="btn primary large">Save</button>
      </div>
    </form>
  </main>

  <?php $cfg = require __DIR__ . '/../includes/config.php'; ?>
  <script>
  window.APP_CFG = {
    MAPBOX_TOKEN: "<?= htmlspecialchars($cfg['mapbox_token'] ?? '') ?>",
    GOOGLE_KEY: "<?= htmlspecialchars($cfg['google_key'] ?? '') ?>"
  };
  </script>

  <script src="assets/app.js?v=4"></script>
  <script>
/* Robust lightbox (single instance) — works with dynamically inserted images.
   Place this after your app.js include in both pages.
*/
(function(){
  // Create single lightbox elements and attach handlers
  if (document.querySelector('.lightbox-backdrop')) {
    // already present (safety)
    return;
  }

  const backdrop = document.createElement('div');
  backdrop.className = 'lightbox-backdrop';
  backdrop.setAttribute('aria-hidden', 'true');

  const inner = document.createElement('div');
  inner.className = 'lightbox-inner';

  const loader = document.createElement('div');
  loader.className = 'lightbox-loader';
  loader.style.display = 'none';

  const img = document.createElement('img');
  img.className = 'lightbox-img';
  img.alt = 'Photo preview';
  img.style.display = 'none';

  const closeBtn = document.createElement('button');
  closeBtn.className = 'lightbox-close';
  closeBtn.innerHTML = '✕';
  closeBtn.setAttribute('aria-label', 'Close preview');

  // assemble
  inner.appendChild(loader);
  inner.appendChild(img);
  inner.appendChild(closeBtn);
  backdrop.appendChild(inner);
  document.body.appendChild(backdrop);

  // helper functions
  let currentSrc = '';
  function show(src) {
    if (!src) return;
    currentSrc = src;
    backdrop.style.display = 'flex';
    backdrop.setAttribute('aria-hidden', 'false');
    document.body.style.overflow = 'hidden';

    // show loader while image loads
    loader.style.display = '';
    img.style.display = 'none';
    img.src = ''; // reset

    // pre-load image
    const tmp = new Image();
    tmp.onload = function() {
      // success — set src and show
      img.src = src;
      loader.style.display = 'none';
      img.style.display = '';
      // ensure focus for accessibility
      closeBtn.focus({preventScroll:true});
    };
    tmp.onerror = function() {
      loader.style.display = 'none';
      img.style.display = 'none';
      // fallback: show a small error message
      const err = document.createElement('div');
      err.style.color = '#fff';
      err.style.padding = '8px';
      err.textContent = 'Could not load image.';
      // remove any previous error nodes
      const previous = inner.querySelector('.lb-error');
      if (previous) previous.remove();
      err.className = 'lb-error';
      inner.appendChild(err);
      setTimeout(()=> { if (err) err.remove(); }, 2500);
    };
    tmp.src = src;
  }

  function hide() {
    backdrop.style.display = 'none';
    backdrop.setAttribute('aria-hidden', 'true');
    document.body.style.overflow = '';
    img.src = '';
    currentSrc = '';
    // remove any transient error nodes
    const previous = inner.querySelector('.lb-error');
    if (previous) previous.remove();
  }

  // event wiring
  closeBtn.addEventListener('click', hide);
  // click outside to close
  backdrop.addEventListener('click', (ev) => {
    if (ev.target === backdrop) hide();
  });
  // escape key
  document.addEventListener('keydown', (ev) => { if (ev.key === 'Escape') hide(); });

  // delegate clicks/taps on images (works for dynamic inserts)
  document.addEventListener('click', function(e) {
    const t = e.target;
    if (!t) return;
    // Only open when clicking the actual image (not its container) OR clicking inside .training-image wrapper
    let targetImg = null;
    if (t.tagName === 'IMG' && (t.closest('.training-image') || t.closest('#previous-trainings') || t.closest('#training-list') || t.closest('#reg-photo') || t.closest('#photo-preview'))) {
      targetImg = t;
    } else {
      // if clicked wrapper with an image inside
      const wrapper = t.closest('.training-image, #previous-trainings, #training-list, #reg-photo, #photo-preview');
      if (wrapper) {
        targetImg = wrapper.querySelector('img');
      }
    }
    if (targetImg && targetImg.src) {
      // prevent default link behavior if inside an <a>
      if (e.defaultPrevented) return;
      e.preventDefault && e.preventDefault();
      show(targetImg.src);
    }
  }, { passive: false });

})();
</script>

</body>
</html>
