<?php
// work_portal.php
declare(strict_types=1);

/* ---------------- Unified Session Setup ---------------- */
require __DIR__ . '/session_boot.php';
/* ------------------------------------------------------- */

// Debug log (optional): helps confirm the same session ID across pages
// error_log("[work_portal] sid=" . session_id() . " uid=" . (int)($_SESSION['user_id'] ?? 0));

if (empty($_SESSION['user_id'])) {
  header('Location: executive_login.php');
  exit;
}

require __DIR__ . '/../includes/db_pdo_only.php'; // safe DB include (no redirect guards)
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Pragma: no-cache');

/* Fetch executive info */
$me = null;
if (!empty($_SESSION['user_id'])) {
  $stmt = $pdo->prepare('SELECT id, full_name FROM executives WHERE id = :id');
  $stmt->execute([':id' => $_SESSION['user_id']]);
  $me = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Work Portal</title>
  <link rel="stylesheet" href="assets/style.css">
  <style>
    .grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
    }
    .card {
      background: #fff;
      border: 1px solid #e5e7eb;
      border-radius: 12px;
      padding: 14px;
      text-decoration: none;
      display: block;
      transition: box-shadow 0.2s;
    }
    .card:hover {
      box-shadow: 0 6px 14px rgba(0,0,0,.06);
    }
    .title-sm {
      font-weight: 700;
      font-size: 1.05rem;
      margin-bottom: 6px;
    }
    .muted {
      color: #6b7280;
    }
  </style>
</head>
<body>
<main class="container">
  <header class="page-header">
    <h1 class="title">Work Portal</h1>
    <div class="muted">Executive: <?= htmlspecialchars($me['full_name'] ?? '—') ?></div>
  </header>

  <div class="grid">
    <a class="card" href="attendance.php">
      <div class="title-sm">Attendance</div>
      <div class="muted">Check-in (start) and Check-out (end) with geotag</div>
    </a>

    <a class="card" href="index.php">
      <div class="title-sm">Data Collection Form</div>
      <div class="muted">Open registration (index.php)</div>
    </a>
  </div>
</main>
</body>
</html>
