<?php
// session_boot.php — unified session setup (final stable)
declare(strict_types=1);

if (session_status() !== PHP_SESSION_ACTIVE) {
  $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
          || ((int)($_SERVER['SERVER_PORT'] ?? 80) === 443);

  // Force our own session name, so PHPSESSID is ignored completely
  session_name('SBMSESSID');

  // Always use a consistent path
  $cookiePath = '/sbm/public';

  $params = [
    'lifetime' => 0,
    'path'     => $cookiePath,
    // no domain on purpose — current host only
    'secure'   => $isHttps,
    'httponly' => true,
    'samesite' => 'Lax',
  ];

  session_set_cookie_params($params);
  session_start();

  // Just to debug once (optional):
  // error_log("Session started: " . session_id());
}
?>
