<?php
// require_assignment.php
declare(strict_types=1);
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}

/**
 * Public pages (NO enforcement here).
 * Add any other public scripts if needed (e.g., forgot_password.php).
 */
$PUBLIC_PAGES = [
  'executive_login.php',
  'login_action.php',
  'volunteer_register.php',
  'check_available.php',
   'logout.php', 
];

$curr = basename($_SERVER['PHP_SELF'] ?? '');

// If current script is public, do not enforce anything.
if (in_array($curr, $PUBLIC_PAGES, true)) {
  return;
}

// Clear assignment helper (only for protected pages)
if (isset($_GET['clear_assignment'])) {
  unset($_SESSION['assignment']);
  header('Location: volunteer_register.php');
  exit;
}

// 1) If not logged in -> go to Executive Login
if (empty($_SESSION['user_id'])) {
  header('Location: executive_login.php');
  exit;
}

// 2) If logged in but no duty assignment -> go to Executive Registration
if (empty($_SESSION['assignment'])) {
  header('Location: volunteer_register.php');
  exit;
}

// Expose $assignment for protected pages
$assignment = $_SESSION['assignment'];
