<?php
// /sbm/public/logout.php
declare(strict_types=1);

// Always use the same unified session bootstrap
require __DIR__ . '/session_boot.php'; // <-- very important

// Wipe all session data
$_SESSION = [];

// Destroy server-side session
if (session_status() === PHP_SESSION_ACTIVE) {
    // Close and destroy current session storage
    session_destroy();
}

// Proactively expire the session cookie on common paths
$cookieName = session_name(); // "SBMSESSID"
$cp = session_get_cookie_params();
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || ((int)($_SERVER['SERVER_PORT'] ?? 80) === 443);

// Try multiple paths to be extra-safe (covers earlier deployments)
$paths = array_unique([
    $cp['path'] ?: '/',
    '/',
    '/sbm',
    '/sbm/public',
]);

foreach ($paths as $path) {
    // expire with/without domain just in case
    setcookie($cookieName, '', time() - 3600, $path, '', $isHttps, true);
    if (!empty($cp['domain'])) {
        setcookie($cookieName, '', time() - 3600, $path, $cp['domain'], $isHttps, true);
    }
}

// No caching of this response
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Pragma: no-cache');

// Redirect to login
header('Location: executive_login.php?success=' . urlencode('Logged out successfully. Please login again.'));
exit;
