<?php
declare(strict_types=1);
require __DIR__ . '/session_boot.php';
if (!empty($_SESSION['user_id'])) {
  header('Location: attendance.php'); exit;
}



$error = $_GET['error'] ?? '';
$success = $_GET['success'] ?? '';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Executive Login - WS</title>
  <link rel="icon" type="image/png" href="favicon-ws.png">
  <link rel="stylesheet" href="assets/bootstrap.min.css">
<link rel="stylesheet" href="assets/gov-ui.css?v=1">
<style>
  .password-wrapper{position:relative}
  .password-wrapper .toggle-password{
    position:absolute; right:12px; top:50%; transform:translateY(-50%);
    display:inline-flex; align-items:center; justify-content:center;
    width:32px; height:32px; cursor:pointer; border:0; background:transparent; padding:0;
    color:#6c757d;
  }
  .password-wrapper .toggle-password svg{width:22px; height:22px; stroke:currentColor; fill:none; stroke-width:2}
</style>

</head>
<body class="p-3 p-md-5">
    <!-- Top Home button -->
<div class="top-actions">
  <a class="home-btn" href="home.php">Home</a>
</div>

<style>
  /* Top bar wrapper */
  .top-actions {
    display: flex;
    justify-content: flex-start;
    align-items: center;
    max-width: 560px;
    margin: 0 auto 10px;
  }

  /* Green Home button (same as other page) */
  .home-btn {
    background: linear-gradient(135deg, #2fa84f, #1f7a39);
    color: #fff;
    text-decoration: none;
    border: none;
    padding: 8px 14px;
    border-radius: 10px;
    font-weight: 700;
    box-shadow: 0 2px 4px rgba(31, 122, 57, 0.2);
    transition: filter 0.2s ease-in-out;
  }

  .home-btn:hover {
    filter: brightness(1.08);
  }
</style>

  <div class="container" style="max-width:560px">
    <div class="text-center mb-4">
      <h2 class="fw-bold">Executive Login</h2>
      <p class="text-muted m-0">Use your registered phone number and password.</p>
    </div>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
      <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <div class="card shadow-sm">
      <div class="card-body p-4">
        <form method="post" action="login_action.php" autocomplete="off" novalidate>
          <div class="mb-3">
            <!--<label for="phone" class="form-label">Phone Number</label>-->
            <input type="text" pattern="\d{10}" maxlength="10" class="form-control" id="phone" name="phone" placeholder="10-digit mobile (without +91)" required>
            <!--<div class="form-text">Enter exactly 10 digits.</div>-->
          </div>
          <div class="mb-3">
            <!--<label for="password" class="form-label">Password</label>-->
            <div class="password-wrapper">
  <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
  <button type="button" class="toggle-password" aria-label="Show password">
    <svg class="eye-open" viewBox="0 0 24 24">
      <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7S1 12 1 12z" stroke-linecap="round" stroke-linejoin="round"/>
      <circle cx="12" cy="12" r="3" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
    <svg class="eye-closed" viewBox="0 0 24 24" style="display:none">
      <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7S1 12 1 12z" stroke-linecap="round" stroke-linejoin="round"/>
      <circle cx="12" cy="12" r="3" stroke-linecap="round" stroke-linejoin="round"/>
      <line x1="2" y1="2" x2="22" y2="22" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </button>
</div>
<script>
  (function(){
    function $(s,ctx=document){return ctx.querySelector(s)}
    function $$(s,ctx=document){return Array.from(ctx.querySelectorAll(s))}
    $$('.password-wrapper').forEach(wrap=>{
      const input = $('input[type="password"], input[type="text"]', wrap);
      const btn   = $('.toggle-password', wrap);
      const open  = $('.eye-open', wrap);
      const off   = $('.eye-closed', wrap);

      btn?.addEventListener('click', ()=>{
        const isPwd = input.type === 'password';
        input.type = isPwd ? 'text' : 'password';
        open.style.display = isPwd ? 'none' : 'inline';
        off.style.display  = isPwd ? 'inline' : 'none';
        btn.setAttribute('aria-label', isPwd ? 'Hide password' : 'Show password');
      });
    });
  })();
</script>


          </div>
          <button class="btn btn-primary btn-lg w-100" type="submit">Login</button>
        </form>
       <div class="text-center below-cta">
  <a href="volunteer_register.php">New here? Register as Executive</a>
</div>
      </div>
    </div>
  </div>
</body>
</html>
