<?php
// check_available.php
declare(strict_types=1);
header('Content-Type: application/json');

require __DIR__ . '/../includes/db.php';

$type = $_GET['type'] ?? '';
$value = trim($_GET['value'] ?? '');

if ($type === 'phone') {
  $ok = preg_match('/^[0-9]{10}$/', $value);
  if (!$ok) { echo json_encode(['available'=>false]); exit; }
  $stmt = $pdo->prepare('SELECT 1 FROM executives WHERE phone = :v LIMIT 1');
  $stmt->execute(['v'=>$value]);
  $exists = (bool)$stmt->fetchColumn();
  echo json_encode(['available'=> !$exists ]);
  exit;
}
if ($type === 'email') {
  if (!filter_var($value, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['available'=>false]); exit;
  }
  $stmt = $pdo->prepare('SELECT 1 FROM executives WHERE email = :v LIMIT 1');
  $stmt->execute(['v'=>$value]);
  $exists = (bool)$stmt->fetchColumn();
  echo json_encode(['available'=> !$exists ]);
  exit;
}

echo json_encode(['available'=>false]);
