<?php
declare(strict_types=1);

// Minimal, no guards/redirects. Uses your existing config.php.
$cfg = require __DIR__ . '/config.php';

if (!isset($cfg['db'])) {
    throw new RuntimeException('Database configuration missing in config.php');
}

$db = $cfg['db'];

$dsn = sprintf(
    'mysql:host=%s;dbname=%s;charset=%s',
    $db['host'],
    $db['name'],
    $db['charset'] ?? 'utf8mb4'
);

$pdo = new PDO($dsn, $db['user'], $db['pass'], [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
]);
