<?php
// includes/auth.php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
require __DIR__ . '/db.php';

function auth_login(string $username, string $password): array {
  global $pdo;
  $st = $pdo->prepare('SELECT id, username, password_hash, role, is_active FROM admin_users WHERE username = :u LIMIT 1');
  $st->execute(['u' => $username]);
  $u = $st->fetch();
  if (!$u || !$u['is_active']) {
    return ['success'=>false,'message'=>'Invalid credentials'];
  }
  if (!password_verify($password, $u['password_hash'])) {
    return ['success'=>false,'message'=>'Invalid credentials'];
  }
  // rotate session id
  session_regenerate_id(true);
  $_SESSION['admin'] = [
    'id' => (int)$u['id'],
    'username' => $u['username'],
    'role' => $u['role'],
    'login_at' => date('Y-m-d H:i:s')
  ];
  return ['success'=>true];
}

function auth_logout(): void {
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
  }
  session_destroy();
}

function auth_user(): ?array {
  return $_SESSION['admin'] ?? null;
}

function require_login(array $roles = []): void {
  $u = auth_user();
  if (!$u) {
    header('Location: /admin/login.php');
    exit;
  }
  if ($roles && !in_array($u['role'], $roles, true)) {
    http_response_code(403);
    echo 'Forbidden';
    exit;
  }
}
